import java.awt.Graphics;
import java.awt.Color;

public class MoreGraphicsExamples {
	
	public static final int DP_WIDTH = 300;
	public static final int DP_HEIGHT = 200;
	public static final int STANDARD_TRUCK_SIZE = 20;
	public static final int ANIMATION_STEP = 10;
	public static final int ANIMATION_DELAY = 100;

	public static void main(String[] args) {
		DrawingPanel dp = new DrawingPanel(DP_WIDTH, DP_HEIGHT);
		dp.setBackground(Color.LIGHT_GRAY);
		Graphics gr = dp.getGraphics();
		drawTruck0(gr);
		drawTruck1(gr, 0, 0);
		drawTruck1(gr, 100, 80);
		//drawTruck2(gr, 0, 0, 20);
		//drawTruck2(gr, 90, 110, 10);
		//movingTruck (dp, gr, 20, 70, 30);
	}
	// drawTruck0 - hard coded location and size
	private static void drawTruck0(Graphics gr) {
		// draw truck body
	    gr.setColor(Color.BLACK);
	    gr.fillRect(0, 0, 100, 50);   
	    
        // draw truck window
	    gr.setColor(Color.CYAN);
	    gr.fillRect(70, 10, 30, 20);  
	        
	    // draw truck wheels
	    gr.setColor(Color.RED);
        gr.fillOval(10, 40, 20, 20);
        gr.fillOval(70, 40, 20, 20);               
	    }
	
	// drawTruck1 - parameterized location and hard coded size
	private static void drawTruck1(Graphics gr, int x, int y) {
		// draw truck body
	    gr.setColor(Color.BLACK);
	    gr.fillRect(x, y, 100, 50);      
	    
        // draw truck window
	    gr.setColor(Color.CYAN);
	    gr.fillRect(x + 70 , y + 10, 30, 20);  
	        
	    // draw truck wheels
	    gr.setColor(Color.RED);
        gr.fillOval(x + 10, y + 40, 20, 20);
        gr.fillOval(x + 70, y + 40, 20, 20);               
	    }
	
	// drawTruck2 - parameterized location and hard coded size
	// (x,y) is the location of the truck
	// z is the diameter of the wheel, which determines the overall truck size
	private static void drawTruck2(Graphics gr, int x, int y, int size) {
		double adjust = (double)size/(double)STANDARD_TRUCK_SIZE;
		// draw truck body
	    gr.setColor(Color.BLACK);
	    gr.fillRect(x, y, (5 * size), (int)(2.5 * size));      
	    
        // draw truck window
	    gr.setColor(Color.CYAN);
	    gr.fillRect(x + (int)(70 * adjust), y + (int)(10 * adjust), (int)(1.5 * size), size);  
	        
	    // draw truck wheels
	    gr.setColor(Color.RED);
        gr.fillOval(x + (int)(10 * adjust), y + (int)(40 * adjust), size, size);
        gr.fillOval(x + (int)(70 * adjust), y + (int)(40 * adjust), size, size);               
	    }
	
	private static void drawTruckError(Graphics gr, int x, int y, int size) {
		double adjust = (double)size/(double)STANDARD_TRUCK_SIZE;
		// draw truck body
	    gr.setColor(Color.BLACK);
	    gr.fillRect(x, y, (5 * size), (int)(2.5 * size));      
	    
        // draw truck window
	    gr.setColor(Color.CYAN);
	    gr.fillRect(x + 70, y + 10, (int)(1.5 * size), size);  
	        
	    // draw truck wheels
	    gr.setColor(Color.RED);
        gr.fillOval(x + 10, y + 40, size, size);
        gr.fillOval(x + 70, y + 40, size, size);               
	    }
	
	// movingTruck() - parameterized location and size, plus animation
	// (x,y) is the location of the truck
	// size is the diameter of the wheel, which determines the overall truck size
	// animation type determined by constants for STEP and SIZE
	private static void movingTruck(DrawingPanel dp, Graphics gr, int x, int y, int size) {
		// each loop draws truck again, 10 pixels more to the right
		for (int i = x; i<=DP_WIDTH; i+=ANIMATION_STEP) {
			gr.setColor(Color.LIGHT_GRAY);
			gr.fillRect(0, 0, DP_WIDTH, DP_HEIGHT);
			drawTruck2(gr, i, y, size);
			dp.sleep(ANIMATION_DELAY);
		}
	}
}
	
